CREATE TABLE #RsNotasEnt(CD_EMP INT,
					  CD_FILIAL INT,
					  CD_NF INT,
					  VLR_ICMS_DESONERADO MONEY)

CREATE TABLE #RsNotasSai(CD_EMP INT,
					  CD_FILIAL INT,
					  CD_NF INT,
					  VLR_ICMS_DESONERADO MONEY)

INSERT INTO #RsNotasEnt
SELECT
	CD_EMP,
	CD_FILIAL,
	CD_NF,
	SUM(VLR_ICMS_DESONERADO)
FROM
	EST_NF_ENT_IT
WHERE
	VLR_ICMS_DESONERADO>0
	AND DT_ENT>'2015-06-01'
GROUP BY
	CD_EMP,
	CD_FILIAL,
	CD_NF

UPDATE
	e
SET 
	e.VLR_ICMS_DESONERADO = s.VLR_ICMS_DESONERADO
FROM
	EST_NF_ENT e INNER JOIN #RsNotasEnt s ON
	e.CD_EMP = s.CD_EMP AND
	e.CD_FILIAL = s.CD_FILIAL AND
	e.CD_NF = s.CD_NF 
WHERE
	e.VLR_ICMS_DESONERADO <> s.VLR_ICMS_DESONERADO
	

INSERT INTO #RsNotasSai
SELECT
	CD_EMP,
	CD_FILIAL,
	CD_NF,
	SUM(VLR_ICMS_DESONERADO)
FROM
	EST_NF_SAI_IT
WHERE
	VLR_ICMS_DESONERADO>0
	AND DT_EMI_NF>'2015-06-01'
GROUP BY
	CD_EMP,
	CD_FILIAL,
	CD_NF

UPDATE
	s
SET 
	s.VLR_ICMS_DESONERADO = s.VLR_ICMS_DESONERADO
FROM
	EST_NF_SAI s INNER JOIN #RsNotasSai sd ON
	s.CD_EMP = sd.CD_EMP AND
	s.CD_FILIAL = sd.CD_FILIAL AND
	s.CD_NF = sd.CD_NF 
WHERE
	s.VLR_ICMS_DESONERADO <> sd.VLR_ICMS_DESONERADO

DROP TABLE #RsNotasSai
DROP TABLE #RsNotasEnt
